/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.flag;

import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.flag.AbstractFlag;
import de.z0rdak.yawp.core.flag.BooleanFlag;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.FlagType;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.IFlagContainer;
import de.z0rdak.yawp.core.flag.IntFlag;
import de.z0rdak.yawp.core.flag.ListFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;

public class RegionFlags
implements IFlagContainer {
    private final Map<String, IFlag> flags = new HashMap<String, IFlag>();

    public RegionFlags() {
    }

    public RegionFlags(class_2487 nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 nbt = new class_2487();
        this.flags.forEach((flagName, iFlag) -> {
            if (RegionFlag.contains(flagName)) {
                nbt.method_10566(flagName, iFlag.serializeNBT());
            }
        });
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.flags.clear();
        for (String key : nbt.method_10541()) {
            if (!RegionFlag.contains(key)) continue;
            class_2487 flagNbt = nbt.method_10562(key);
            FlagType flagType = FlagType.of(flagNbt.method_10558("flag_type"));
            if (flagType != null) {
                AbstractFlag flag = switch (flagType) {
                    default -> throw new MatchException(null, null);
                    case FlagType.BOOLEAN_FLAG -> new BooleanFlag(flagNbt);
                    case FlagType.LIST_FLAG -> new ListFlag(flagNbt);
                    case FlagType.INT_FLAG -> new IntFlag(flagNbt);
                };
                this.flags.put(key, flag);
                continue;
            }
            Constants.LOGGER.warn("Error reading entry for flag '{}'.", (Object)key);
        }
    }

    @Override
    public void put(IFlag flag) {
        this.flags.put(flag.getName(), flag);
    }

    @Override
    public IFlag get(String flagName) {
        return this.flags.get(flagName);
    }

    @Override
    public void remove(String flag) {
        this.flags.remove(flag);
    }

    @Override
    public boolean contains(String flag) {
        return this.flags.containsKey(flag);
    }

    @Override
    public void clear() {
        this.flags.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.flags.isEmpty();
    }

    @Override
    public int size() {
        return this.flags.size();
    }

    @Override
    public Set<Map.Entry<String, IFlag>> flagEntries() {
        return Collections.unmodifiableSet(this.flags.entrySet());
    }

    @Override
    public List<IFlag> flags() {
        return List.copyOf(this.flags.values());
    }

    @Override
    public List<IFlag> flags(FlagState state) {
        return this.flags.values().stream().filter(flag -> flag.getState() == state).toList();
    }

    @Override
    public FlagState flagState(String flagName) {
        if (this.contains(flagName)) {
            return this.flags.get(flagName).getState();
        }
        return FlagState.UNDEFINED;
    }

    @Override
    public boolean isFlagDefined(@NotNull String flagName) {
        return this.flagState(flagName) != FlagState.UNDEFINED;
    }

    @Override
    public boolean isAllowedOrDenied(@NotNull String flagName) {
        FlagState flagState = this.flagState(flagName);
        return flagState == FlagState.ALLOWED || flagState == FlagState.DENIED;
    }

    public RegionFlags deepCopy() {
        return new RegionFlags(this.serializeNBT());
    }

    public Map<String, IFlag> getActiveFlags() {
        HashMap<String, IFlag> activeFlags = new HashMap<String, IFlag>();
        this.flags.forEach((k, v) -> {
            if (v.isActive()) {
                activeFlags.put((String)k, (IFlag)v);
            }
        });
        return activeFlags;
    }
}

